/// <reference types="react" />
import { OUIAProps } from '../../helpers';
export declare enum ContentVariants {
    h1 = "h1",
    h2 = "h2",
    h3 = "h3",
    h4 = "h4",
    h5 = "h5",
    h6 = "h6",
    p = "p",
    a = "a",
    small = "small",
    blockquote = "blockquote",
    pre = "pre",
    hr = "hr",
    ul = "ul",
    ol = "ol",
    dl = "dl",
    li = "li",
    dt = "dt",
    dd = "dd"
}
export interface ContentProps extends React.HTMLProps<HTMLElement>, OUIAProps {
    /** The content component. If none provided, it will be a 'div' and styling will be applied to all its child components. */
    component?: 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p' | 'a' | 'small' | 'blockquote' | 'pre' | 'hr' | 'ul' | 'ol' | 'dl' | 'li' | 'dt' | 'dd';
    /** Children rendered within the Content. */
    children?: React.ReactNode;
    /** Additional classes added to the Content. */
    className?: string;
    /** Modifies the list (ul, ol and dl components) to have plain styling. */
    isPlainList?: boolean;
    /** Flag to indicate the link (or all links within the content) has visited styles applied if the browser determines the link has been visited. */
    isVisitedLink?: boolean;
    /** Flag to indicate the content has editorial styling. This styling increases the font size of body text and small text by one tier, increasing body text to large and small text to the previous body text size.  */
    isEditorial?: boolean;
    /** Value to overwrite the randomly generated data-ouia-component-id. */
    ouiaId?: number | string;
    /** Set the value of data-ouia-safe. Only set to true when the component is in a static state, i.e. no animations are occurring. At all other times, this value must be false. */
    ouiaSafe?: boolean;
}
export declare const Content: React.FunctionComponent<ContentProps>;
//# sourceMappingURL=Content.d.ts.map