# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

profile-window-heading = Velg en { -brand-short-name }-profil
profile-window-body = Hold jobben og den personlige surfingen din, inkludert ting som passord og bokmerker, helt adskilt. Eller opprett profiler for alle som bruker denne enheten.
# This checkbox appears in the Choose profile window that appears when the browser is opened. "Show this" refers to this window, which is displayed when the checkbox is enabled.
profile-window-checkbox-label-2 =
    .label = Velg en profil når { -brand-short-name } åpnes
# This subcopy appears below the checkbox when it is unchecked
profile-window-checkbox-subcopy = { -brand-short-name } vil åpne med profilen du brukte sist.
profile-window-create-profile = Opprett en profil
profile-card-edit-button =
    .title = Rediger profil
    .aria-label = Rediger profil
profile-card-delete-button =
    .title = Slett profil
    .aria-label = Slett profil
# Variables
#   $profileName (string) - The name of the profile
profile-card =
    .title = Åpne { $profileName }
    .aria-label = Åpne { $profileName }
# Variables
#   $number (number) - The number of the profile
default-profile-name = Profil { $number }
# The word 'original' is used in the sense that it is the initial or starting profile when you install Firefox.
original-profile-name = Originalprofil
default-desktop-shortcut-name = { -brand-short-name }
edit-profile-page-title = Rediger profil
edit-profile-page-header = Rediger profilen din
edit-profile-page-profile-name-label = Profilnavn
edit-profile-page-theme-header-2 =
    .label = Tema
edit-profile-page-explore-themes = Utforsk flere temaer
edit-profile-page-desktop-shortcut-header = Opprett snarvei på skrivebordet
edit-profile-page-avatar-header-2 =
    .label = Avatar
edit-profile-page-delete-button =
    .label = Slett
edit-profile-page-avatar-selector-opener-link = Rediger
avatar-selector-icon-tab = Ikon
avatar-selector-custom-tab = Tilpasset
avatar-selector-cancel-button =
    .label = Avbryt
avatar-selector-save-button =
    .label = Lagre
avatar-selector-upload-file = Last opp en fil
avatar-selector-drag-file = Eller dra en fil hit
avatar-selector-add-image = Legg til et bilde
avatar-selector-crop = Beskjær
edit-profile-page-no-name = Gi denne profilen et navn for å hjelpe deg med å finne den senere. Bytt navn når som helst.
edit-profile-page-duplicate-name = Profilnavnet er allerede i bruk. Prøv et annet navn.
edit-profile-page-profile-saved = Lagret
new-profile-page-title = Ny profil
new-profile-page-header = Tilpass din nye profil
new-profile-page-header-description = Hver profil har sin egen nettleserhistorikk og innstillinger atskilt fra de andre profilene dine. I tillegg er { -brand-short-name } sin sterke personvernbeskyttelse på som standard.
new-profile-page-learn-more = Les mer
new-profile-page-input-placeholder =
    .placeholder = Velg et navn som «Arbeid» eller «Personlig»
new-profile-page-done-button =
    .label = Ferdig med redigering
# Variables
#   $profilename (String) - The name of the copied profile.
copied-profile-page-header = Din kopi av { $profilename } er klar for tilpasning
copied-profile-page-header-description = Vi kopierte dine data og innstillinger til en ny profil. Gi den et navn, velg et utseende og gjør den til din egen.
profile-window-title-2 = { -brand-short-name } - Velg en profil
profile-window-logo =
    .alt = { -brand-short-name }-logo

## Delete profile dialogue that allows users to review what they will lose if they choose to delete their profile. Each item (open windows, etc.) is displayed in a table, followed by a column with the number of items.

# Variables
#   $profilename (String) - The name of the profile.
delete-profile-page-title = Slett { $profilename }-profilen
# Variables
#   $profilename (String) - The name of the profile.
delete-profile-header = Vil du slette { $profilename }-profilen?
delete-profile-description = { -brand-short-name } vil permanent slette følgende data fra denne enheten:
# Open is an adjective, as in "browser windows currently open".
delete-profile-windows = Åpne vinduer
# Open is an adjective, as in "browser tabs currently open".
delete-profile-tabs = Åpne faner
delete-profile-bookmarks = Bokmerker
delete-profile-history = Historikk (besøkte sider, infokapsler, nettstedsdata)
delete-profile-autofill = Autofylldata (adresser, betalingsmåter)
delete-profile-logins = Passord

##

# Button label
delete-profile-cancel = Avbryt
# Button label
delete-profile-confirm = Slett

## These strings are color themes available to select from the profile selection screen. Theme names should be localized.

# The default light theme
profiles-light-theme = Lys
# The default dark theme
profiles-dark-theme = Mørk
# The default system theme
profiles-system-theme = System
profiles-system-theme-title =
    .title = Bruk systemtema
# This light theme features sunny colors such as goldenrod and pale yellow. Its name evokes the color of a marigold flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-marigold-theme-2 = Gul ringblomst
# This light theme features various shades of soft, muted purples. Its name evokes the color of a lavender flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-lavender-theme-2 = Blek lavendel
# This light theme features very pale green tones. Its name evokes the color of pale green mint ice cream. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-lichen-theme-2 = Myntegrønn
# This light theme features various shades of pink ranging from pale to bold. Its name evokes the color of a pink magnolia flower. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-magnolia-theme-2 = Rosa magnolia
# Ocean blue is a dark theme that features very dark blues and black. Its name evokes the color of the deep ocean water. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-ocean-theme-2 = Havblå
# This dark theme features warm oranges, dark mahogany browns, and earthy red/brown colors. The name evokes the earthy colors of brick masonry. This name can be translated directly if it's easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-terracotta-theme-2 = Mursteinsrød
# This dark theme features forest green, dusky green with a gray undertone, and a muted sage green. Its name evokes the rich color of green moss in the forest. This name can be translated directly if its easily understood in your language, or adapted to a more natural sounding name that fits the color scheme.
profiles-moss-theme-2 = Mosegrønn
profiles-gray-theme = Grå
profiles-gray-theme-title =
    .title = Bruk grått tema
profiles-yellow-theme = Gul
profiles-yellow-theme-title =
    .title = Bruk gult tema
profiles-orange-theme = Oransje
profiles-orange-theme-title =
    .title = Bruk oransje tema
profiles-red-theme = Rød
profiles-red-theme-title =
    .title = Bruk rødt tema
profiles-pink-theme = Rosa
profiles-pink-theme-title =
    .title = Bruk rosa tema
profiles-purple-theme = Lilla
profiles-purple-theme-title =
    .title = Bruk lilla tema
profiles-violet-theme = Fiolett
profiles-violet-theme-title =
    .title = Bruk fiolett tema
profiles-blue-theme = Blå
profiles-blue-theme-title =
    .title = Bruk blått tema
profiles-green-theme = Grønn
profiles-green-theme-title =
    .title = Bruk grønt tema
profiles-cyan-theme = Turkis
profiles-cyan-theme-title =
    .title = Bruk turkis tema
profiles-custom-theme-title =
    .title = Bruk et tilpasset tema

## Data collection settings changed (multi-profile)

# Full infobar message with inline bold title followed by body text
multiprofile-data-collection-message = <strong>Innstillingene for datainnsamling er endret.</strong> Endringene som er gjort i en annen profil gjelder for alle profiler på denne enheten.
# Primary button label to open the Data collection section in Settings
multiprofile-data-collection-view-settings = Vis innstillinger
# Secondary button label to dismiss the infobar without action
multiprofile-data-collection-dismiss = Ignorer

## Alternative text for default profile icons

book-avatar-alt =
    .alt = Bok
briefcase-avatar-alt =
    .alt = Dokumentmappe
picture-avatar-alt =
    .alt = Bilde
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar-alt =
    .alt = Håndverk
flower-avatar-alt =
    .alt = Blomst
folder-avatar-alt =
    .alt = Mappe
hammer-avatar-alt =
    .alt = Hammer
heart-avatar-alt =
    .alt = Hjerte
heart-rate-avatar-alt =
    .alt = Hjertefrekvens
clock-avatar-alt =
    .alt = Klokke
leaf-avatar-alt =
    .alt = Blad
lightbulb-avatar-alt =
    .alt = Lyspære
makeup-avatar-alt =
    .alt = Sminke
# Message refers to a text message, not a traditional letter/envelope message
message-avatar-alt =
    .alt = Melding
musical-note-avatar-alt =
    .alt = Musikknote
palette-avatar-alt =
    .alt = Palett
paw-print-avatar-alt =
    .alt = Poteavtrykk
plane-avatar-alt =
    .alt = Fly
# Present refers to a gift box, not the current time period
present-avatar-alt =
    .alt = Gave
shopping-avatar-alt =
    .alt = Handlevogn
soccer-ball-avatar-alt =
    .alt = Fotball
sparkle-single-avatar-alt =
    .alt = Glitre
star-avatar-alt =
    .alt = Stjerne
video-game-controller-avatar-alt =
    .alt = Videospillkontroller
custom-avatar-alt =
    .alt = Tilpasset avatar
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar-alt =
    .alt = Globus
# Diamond refers to the precious stone, not the geometric shape
diamond-avatar-alt =
    .alt = Diamant
barbell-avatar-alt =
    .alt = Vektstang
bike-avatar-alt =
    .alt = Sykkel

## Tooltips for default avatar icons

book-avatar = Bok
briefcase-avatar = Dokumentmappe
clock-avatar = Klokke
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar = Håndverk
custom-avatar = Tilpasset avatar
# Diamond refers to the precious stone, not the geometric shape
diamond-avatar = Diamant
flower-avatar = Blomst
folder-avatar = Mappe
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar = Globus
hammer-avatar = Hammer
heart-avatar = Hjerte
heart-rate-avatar = Hjertefrekvens
leaf-avatar = Blad
lightbulb-avatar = Lyspære
makeup-avatar = Sminke
# Message refers to a text message, not a traditional letter/envelope message
message-avatar = Melding
musical-note-avatar = Musikknote
palette-avatar = Palett
paw-print-avatar = Poteavtrykk
picture-avatar = Bilde
plane-avatar = Fly
# Present refers to a gift box, not the current time period
present-avatar = Gave
shopping-avatar = Handlevogn
soccer-ball-avatar = Fotball
sparkle-single-avatar = Glitre
star-avatar = Stjerne
video-game-controller-avatar = Videospillkontroller
custom-avatar-crop-back-button =
    .aria-label = Tilbake
custom-avatar-crop-view =
    .aria-label = Beskjær bildevisning
custom-avatar-crop-area =
    .aria-label = Juster beskjæringsområdet
custom-avatar-drag-handle =
    .aria-label = Endre størrelsen på beskjæringsområdet
profiles-appmenu-callout-tour-title = Den nye profilen din er klar til bruk
# "Spin up another" means creating another profile, “Hop between your digital lives" is referring to switching between different profiles such as work, personal, etc.
profiles-appmenu-callout-tour-subtitle = I ☰-menyen kan du trykke på profilnavnet ditt for å opprette en ny, redigere denne eller bytte mellom de digitale livene dine.
profiles-appmenu-callout-tour-primary-button = Vis meg hvordan
barbell-avatar = Vektstang
bike-avatar = Sykkel

## Tooltips for default avatar icons

barbell-avatar-tooltip =
    .tooltiptext = Bruk vektstang-avatar
bike-avatar-tooltip =
    .tooltiptext = Bruk sykkel-avatar
book-avatar-tooltip =
    .tooltiptext = Bruk bok-avatar
briefcase-avatar-tooltip =
    .tooltiptext = Bruk koffert-avatar
picture-avatar-tooltip =
    .tooltiptext = Bruk bilde-avatar
# Craft refers to hobby arts and crafts, represented by a button/fastener commonly found on clothing like shirts
craft-avatar-tooltip =
    .tooltiptext = Bruk håndverks-avatar
# Globe refers to the generic globe/world icon that appears in browser tabs when a website doesn't have its own favicon.
globe-avatar-tooltip =
    .tooltiptext = Bruk globus-avatar
diamond-avatar-tooltip =
    .tooltiptext = Bruk diamant-avatar
flower-avatar-tooltip =
    .tooltiptext = Bruk blomster-avatar
folder-avatar-tooltip =
    .tooltiptext = Bruk mappe-avatar
hammer-avatar-tooltip =
    .tooltiptext = Bruk hammer-avatar
heart-avatar-tooltip =
    .tooltiptext = Bruk hjerte-avatar
heart-rate-avatar-tooltip =
    .tooltiptext = Bruk hjertefrekvens-avatar
clock-avatar-tooltip =
    .tooltiptext = Bruk klokke-avatar
leaf-avatar-tooltip =
    .tooltiptext = Bruk blad-avatar
lightbulb-avatar-tooltip =
    .tooltiptext = Bruk lyspære-avatar
makeup-avatar-tooltip =
    .tooltiptext = Bruk sminke-avatar
# Message refers to a text message, not a traditional letter/envelope message
message-avatar-tooltip =
    .tooltiptext = Bruk meldings-avatar
musical-note-avatar-tooltip =
    .tooltiptext = Bruk musikknote-avatar
palette-avatar-tooltip =
    .tooltiptext = Bruk palett-avatar
paw-print-avatar-tooltip =
    .tooltiptext = Bruk poteavtrykk-avatar
plane-avatar-tooltip =
    .tooltiptext = Bruk fly-avatar
# Present refers to a gift box, not the current time period
present-avatar-tooltip =
    .tooltiptext = Bruk gave-avatar
shopping-avatar-tooltip =
    .tooltiptext = Bruk handlevogn-avatar
soccer-ball-avatar-tooltip =
    .tooltiptext = Bruk fotball-avatar
sparkle-single-avatar-tooltip =
    .tooltiptext = Bruk glitre-avatar
star-avatar-tooltip =
    .tooltiptext = Bruk stjerne-avatar
video-game-controller-avatar-tooltip =
    .tooltiptext = Bruk videospillkontroller-avatar
