% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standata.R
\name{standata}
\alias{standata}
\alias{make_standata}
\title{Stan data for Bayesian models}
\usage{
standata(object, ...)

make_standata(formula, ...)
}
\arguments{
\item{object}{A formula object whose class will determine which method will
be used. A symbolic description of the model to be fitted.}

\item{...}{Further arguments passed to the specific method.}

\item{formula}{Synonym of \code{object} for use in \code{make_standata}.}
}
\value{
A named list of objects containing the required data to fit a
  Bayesian model with \pkg{Stan}.
}
\description{
\code{standata} is a generic function that can be used to
  generate data for Bayesian models to be passed to Stan. Its original use is
  within the \pkg{brms} package, but new methods for use
  with objects from other packages can be registered to the same generic.
}
\details{
See \code{\link{standata.default}} for the default method applied for
\pkg{brms} models. You can view the available methods by typing
\code{methods(standata)}. The \code{make_standata} function is an alias
of \code{standata}.
}
\examples{
sdata1 <- standata(rating ~ treat + period + carry + (1|subject),
                   data = inhaler, family = "cumulative")
str(sdata1)

}
\seealso{
\code{\link{standata.default}}, \code{\link{standata.brmsfit}}
}
