# 2024-11-26 Triage Log

This week saw more regressions than improvements, mostly due to three PRs that performed internal
refactorings that are necessary for further development and modification of the compiler.

Triage done by **@kobzol**.
Revision range: [7d40450b..7db7489f](https://perf.rust-lang.org/?start=7d40450b2df92bdc9dec414b30cf5f7a5979a92e&end=7db7489f9bc274cb60c4956bfa56de0185eb1b9b&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.1%, 3.6%]   | 57    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.0%, 2.7%]   | 100   |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.5%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 7     |
| All ❌✅ (primary)                 | 0.4%  | [-1.5%, 3.6%]  | 68    |


4 Regressions, 2 Improvements, 3 Mixed; 3 of them in rollups
40 artifact comparisons made in total

#### Regressions

Rollup of 8 pull requests [#133219](https://github.com/rust-lang/rust/pull/133219) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ee612c45f00391aff71ec0c52b7fc08fae18c711&end=875df370be806c837f58abb638329905e969ace4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.2%, 1.1%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 1.2%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.2%, 1.1%] | 6     |

- The regressions were on the helloworld benchmark and other tiny crates, and they were reverted
in a follow-up merge commit.
- Marked as triaged.

continue `ParamEnv` to `TypingEnv` transition [#133212](https://github.com/rust-lang/rust/pull/133212) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bcfea1f8d253fd43eab36832fa601d192ac603d5&end=70e814bd9e532a302763f870c665c5af59c2b632&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.3%, 0.5%] | 5     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.1%, 6.6%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.3%, 0.5%] | 5     |

- Regressions caused by internal refactoring of the type system that is necessary for further
improvements.
- Asked the PR author about the perf. effect of this PR and also
of [#133242](https://github.com/rust-lang/rust/pull/133242) (mentioned below).
- Not marking as triaged.

Rollup of 5 pull requests [#133280](https://github.com/rust-lang/rust/pull/133280) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=318f96a8cf3eca5c4aaf60a992f349bce5c3fd41&end=0b1bf71a71c2a1d34c212285362530ec2c4e4775&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 7     |
| Regressions ❌ <br /> (secondary)  | 2.0% | [2.0%, 2.0%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 7     |

- The secondary regression is noise.
- The primary regressions look to be genuine, but they are only on a single benchmark and they are
very small, so I don't think that further investigation is needed.
- Marked as triaged.

finish `Reveal` removal [#133242](https://github.com/rust-lang/rust/pull/133242) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=826b673412d2f579e7865b6f26bc9771c6d3b097&end=386a7c7ae22a3727c6a06633212d5a95edabdd74&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.2%, 3.6%] | 11    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 24    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.2%, 3.6%] | 11    |

- Similar situation as in [#133212](https://github.com/rust-lang/rust/pull/133212).
- Not marking as triaged.

#### Improvements

Resolve tweaks [#132761](https://github.com/rust-lang/rust/pull/132761) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=78993684f2ba22082197d63627f3e91069911839&end=ee612c45f00391aff71ec0c52b7fc08fae18c711&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.1%] | 68    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.1%, -1.1%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, -0.1%] | 68    |


Drop debug info instead of panicking if we exceed LLVM's capability to represent it [#133194](https://github.com/rust-lang/rust/pull/133194) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=875df370be806c837f58abb638329905e969ace4&end=bcfea1f8d253fd43eab36832fa601d192ac603d5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 2     |


#### Mixed

Rollup of 5 pull requests [#133234](https://github.com/rust-lang/rust/pull/133234) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=70e814bd9e532a302763f870c665c5af59c2b632&end=fda68927475070696fcc9d1f5c9c990f0e1af87a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.2%  | [0.2%, 5.5%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.8%, 0.8%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.9% | [-5.9%, -5.9%] | 1     |
| All ❌✅ (primary)                 | 2.2%  | [0.2%, 5.5%]   | 8     |

- The regression was caused by [#132732](https://github.com/rust-lang/rust/pull/132732).
- Asked the PR author if there is a way to reduce the compilation performance cost.
- Not marking as triaged.

Reduce false positives of tail-expr-drop-order from consumed values (attempt #2) [#131326](https://github.com/rust-lang/rust/pull/131326) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a1f299953656f95004c69b24ad8071d6899fa9da&end=3fee0f12e4f595948f8f54f57c8b7a7a58127124&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 2.3%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.2%, -0.2%] | 19    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.0%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.7% | [-2.2%, 0.2%]  | 20    |

- This was a win on primary benchmarks.
- Marked as triaged.

#124141 preliminaries [#132629](https://github.com/rust-lang/rust/pull/132629) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b1bf71a71c2a1d34c212285362530ec2c4e4775&end=717f5df2c308dfb4b7b8e6c002c11fe8269c4011&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.3%]   | 29    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 16    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 5     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.3%]   | 29    |

- The regressions are caused by changes in the parser that are required for further cleanup and
refactoring work.
- The regressions are genuine, but tiny. The author has deemed them to be unavoidable.
- Already marked as triaged by @nnethercote.
